/*
 * Decompiled with CFR 0.152.
 */
package jace.hardware;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FloppyDisk {
    boolean writeProtected;
    public int headerLength = 0;
    public boolean isNibblizedImage;
    public static final int TRACK_NIBBLE_LENGTH = 6656;
    public static final int TRACK_COUNT = 35;
    public static final int SECTOR_COUNT = 16;
    public static final int HALF_TRACK_COUNT = 70;
    public static final int DISK_NIBBLE_LENGTH = 232960;
    public static final int DISK_PLAIN_LENGTH = 143360;
    public static final int DISK_2MG_LENGTH = 143424;
    public byte[] nibbles = new byte[232960];
    public static int[] DOS_33_SECTOR_ORDER = new int[]{0, 7, 14, 6, 13, 5, 12, 4, 11, 3, 10, 2, 9, 1, 8, 15};
    public static int[] PRODOS_SECTOR_ORDER = new int[]{0, 13, 11, 9, 7, 5, 3, 1, 14, 12, 10, 8, 6, 4, 2, 15};
    public int[] currentSectorOrder;
    public File diskPath;
    static int[] NIBBLE_62 = new int[]{150, 151, 154, 155, 157, 158, 159, 166, 167, 171, 172, 173, 174, 175, 178, 179, 180, 181, 182, 183, 185, 186, 187, 188, 189, 190, 191, 203, 205, 206, 207, 211, 214, 215, 217, 218, 219, 220, 221, 222, 223, 229, 230, 231, 233, 234, 235, 236, 237, 238, 239, 242, 243, 244, 245, 246, 247, 249, 250, 251, 252, 253, 254, 255};
    static int[] NIBBLE_62_REVERSE = new int[256];
    private static boolean DEBUG;
    int VOLUME_NUMBER = 254;
    public static boolean CHECK_NIB_SECTOR_PATTERN_ON_WRITE;

    public FloppyDisk() throws IOException {
    }

    public FloppyDisk(File diskFile) throws IOException {
        FileInputStream input = new FileInputStream(diskFile);
        String name = diskFile.getName().toUpperCase();
        this.readDisk(input, name.endsWith(".PO") || name.endsWith("2MG"));
        this.writeProtected = !diskFile.canWrite();
        this.diskPath = diskFile;
    }

    public void readDisk(InputStream diskFile, boolean prodosOrder) throws IOException {
        this.currentSectorOrder = prodosOrder ? PRODOS_SECTOR_ORDER : DOS_33_SECTOR_ORDER;
        this.isNibblizedImage = true;
        int bytesRead = diskFile.read(this.nibbles);
        if (bytesRead == 143424) {
            this.nibbles = Arrays.copyOfRange(this.nibbles, 64, this.nibbles.length);
            bytesRead = this.nibbles.length;
            this.headerLength = 64;
        }
        if (bytesRead == 143360) {
            this.isNibblizedImage = false;
            this.nibbles = this.nibblize(this.nibbles);
            if (this.nibbles.length != 232960) {
                throw new IOException("Nibblized version is wrong size (expected-actual = " + (232960 - this.nibbles.length) + ")");
            }
        } else if (bytesRead != 232960) {
            throw new IOException("Bad NIB size " + bytesRead + "; JACE only recognizes plain images " + 143360 + " or nibble images " + 232960 + " sizes");
        }
    }

    public byte[] nibblize(byte[] nibbles) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        for (int track = 0; track < 35; ++track) {
            for (int sector = 0; sector < 16; ++sector) {
                this.writeJunkBytes(output, 15);
                this.writeAddressBlock(output, track, sector);
                this.writeJunkBytes(output, 4);
                this.nibblizeBlock(output, track, this.currentSectorOrder[sector], nibbles);
                this.writeJunkBytes(output, 34);
            }
        }
        return output.toByteArray();
    }

    private void writeJunkBytes(ByteArrayOutputStream output, int i) {
        for (int b = 0; b < i; ++b) {
            output.write(255);
        }
    }

    private void writeAddressBlock(ByteArrayOutputStream output, int track, int sector) throws IOException {
        output.write(213);
        output.write(170);
        output.write(150);
        int checksum = 0;
        checksum ^= this.VOLUME_NUMBER;
        output.write(this.getOddEven(this.VOLUME_NUMBER));
        checksum ^= track;
        output.write(this.getOddEven(track));
        output.write(this.getOddEven(sector));
        output.write(this.getOddEven((checksum ^= sector) & 0xFF));
        output.write(222);
        output.write(170);
        output.write(235);
    }

    private byte[] getOddEven(int i) {
        byte[] out = new byte[]{(byte)(0xAA | i >> 1), (byte)(0xAA | i)};
        return out;
    }

    private int decodeOddEven(byte b1, byte b2) {
        int result = (b1 << 1 | 1) & b2 & 0xFF;
        return result;
    }

    private void nibblizeBlock(ByteArrayOutputStream output, int track, int sector, byte[] nibbles) {
        int value;
        int i;
        int offset = (track * 16 + sector) * 256;
        int[] temp = new int[342];
        for (int i2 = 0; i2 < 256; ++i2) {
            temp[i2] = (nibbles[offset + i2] & 0xFF) >> 2;
        }
        int hi = 1;
        int med = 171;
        int low = 85;
        for (int i3 = 0; i3 < 86; ++i3) {
            int value2;
            temp[i3 + 256] = value2 = (nibbles[offset + hi] & 1) << 5 | (nibbles[offset + hi] & 2) << 3 | (nibbles[offset + med] & 1) << 3 | (nibbles[offset + med] & 2) << 1 | (nibbles[offset + low] & 1) << 1 | (nibbles[offset + low] & 2) >> 1;
            hi = hi - 1 & 0xFF;
            med = med - 1 & 0xFF;
            low = low - 1 & 0xFF;
        }
        output.write(213);
        output.write(170);
        output.write(173);
        int last = 0;
        for (i = temp.length - 1; i > 255; --i) {
            value = temp[i] ^ last;
            output.write(NIBBLE_62[value]);
            last = temp[i];
        }
        for (i = 0; i < 256; ++i) {
            value = temp[i] ^ last;
            output.write(NIBBLE_62[value]);
            last = temp[i];
        }
        output.write(NIBBLE_62[last]);
        output.write(222);
        output.write(170);
        output.write(235);
    }

    public void updateTrack(Integer track) {
        if (this.isNibblizedImage) {
            this.updateNibblizedTrack(track);
        }
        if (!this.isNibblizedImage) {
            this.updateDenibblizedTrack(track);
        }
    }

    void updateNibblizedTrack(Integer track) {
        try {
            RandomAccessFile disk = new RandomAccessFile(this.diskPath, "rws");
            disk.seek(track * 6656);
            disk.write(this.nibbles, track * 6656, 6656);
            disk.close();
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(FloppyDisk.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(FloppyDisk.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    void updateDenibblizedTrack(Integer track) {
        try {
            byte[] trackNibbles = new byte[6656];
            byte[] trackData = new byte[4096];
            int i = 0;
            int pos = track * 6656;
            while (i < 6656) {
                trackNibbles[i] = this.nibbles[pos];
                ++i;
                ++pos;
            }
            int pos2 = 0;
            for (int i2 = 0; i2 < 16; ++i2) {
                pos2 = this.locatePattern(pos2, trackNibbles, 213, 170, 150);
                int trackVerify = this.decodeOddEven(trackNibbles[pos2 + 5], trackNibbles[pos2 + 6]);
                int sector = this.decodeOddEven(trackNibbles[pos2 + 7], trackNibbles[pos2 + 8]);
                pos2 = this.locatePattern(pos2, trackNibbles, 222, 170);
                pos2 = this.locatePattern(pos2, trackNibbles, 213, 170, 173);
                int offset = this.currentSectorOrder[sector] * 256;
                this.denibblizeSector(trackNibbles, pos2 + 3, trackData, offset);
                pos2 = this.locatePattern(pos2, trackNibbles, 222, 170, 235);
            }
            try {
                RandomAccessFile disk = new RandomAccessFile(this.diskPath, "rws");
                disk.seek(this.headerLength + track * 256 * 16);
                disk.write(trackData);
                disk.close();
            }
            catch (FileNotFoundException ex) {
                Logger.getLogger(FloppyDisk.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (IOException ex) {
                Logger.getLogger(FloppyDisk.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        catch (Throwable ex) {
            Logger.getLogger(FloppyDisk.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private int locatePattern(int pos, byte[] data, int ... pattern) throws Throwable {
        int max = data.length;
        while (!this.matchPattern(pos, data, pattern)) {
            pos = (pos + 1) % data.length;
            if (--max >= 0) continue;
            throw new Throwable("Could not match pattern!");
        }
        return pos;
    }

    private boolean matchPattern(int pos, byte[] data, int ... pattern) {
        int matched = 0;
        int[] arr$ = pattern;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            int d = data[pos] & 0xFF;
            int i = arr$[i$];
            if (d != i) {
                if (matched > 1) {
                    System.out.println("Warning: Issue when interpreting nibbilized disk data: at position " + pos + " pattern byte " + Integer.toString(i, 16) + " doesn't match " + Integer.toString(d, 16));
                }
                return false;
            }
            pos = (pos + 1) % data.length;
            ++matched;
        }
        return true;
    }

    private void denibblizeSector(byte[] source, int pos, byte[] trackData, int offset) {
        int t;
        int i;
        int[] temp = new int[342];
        int current = pos;
        int last = 0;
        for (i = temp.length - 1; i > 255; --i) {
            t = NIBBLE_62_REVERSE[0xFF & source[current++]];
            temp[i] = t ^ last;
            last ^= t;
        }
        for (i = 0; i < 256; ++i) {
            t = NIBBLE_62_REVERSE[0xFF & source[current++]];
            temp[i] = t ^ last;
            last ^= t;
        }
        int p = temp.length - 1;
        for (int i2 = 0; i2 < 256; ++i2) {
            int a = temp[i2] << 2;
            a = a + ((temp[p] & 1) << 1) + ((temp[p] & 2) >> 1);
            trackData[i2 + offset] = (byte)a;
            temp[p] = temp[p] >> 2;
            if (--p >= 256) continue;
            p = temp.length - 1;
        }
    }

    private int reverseLoopkup(int[] table, int value) {
        for (int i = 0; i < table.length; ++i) {
            if (table[i] != value) continue;
            return i;
        }
        return -1;
    }

    static {
        for (int i = 0; i < NIBBLE_62.length; ++i) {
            FloppyDisk.NIBBLE_62_REVERSE[FloppyDisk.NIBBLE_62[i] & 0xFF] = 0xFF & i;
        }
        DEBUG = false;
        CHECK_NIB_SECTOR_PATTERN_ON_WRITE = true;
    }
}

